package com.ejie.ab04b.service.nora;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab04b.dao.nora.PaisDao;
import com.ejie.ab04b.model.nora.Pais;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * PaisServiceImpl generated by UDA, 13-Jan-2017 12:55:53.
 * 
 * @author UDA
 */

@Service(value = "paisService")
public class PaisServiceImpl implements PaisService {

	@Autowired()
	private PaisDao paisDao;

	/**
	 * Finds a single row in the Pais table.
	 * 
	 *  pais
	 *            Pais
	 *  Pais
	 *
	 * @param pais the pais
	 * @return the pais
	 */
	public Pais find(Pais pais) {
		return (Pais) this.paisDao.find(pais);
	}

	/**
	 * Finds a list of rows in the Pais table.
	 * 
	 *  pais
	 *            Pais
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Pais>
	 *
	 * @param pais the pais
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<Pais> findAll(Pais pais, JQGridRequestDto jqGridRequestDto) {
		return (List<Pais>) this.paisDao.findAll(pais, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Pais table using like.
	 * 
	 *  pais
	 *            Pais
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Pais>
	 *
	 * @param pais the pais
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<Pais> findAllLike(Pais pais, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Pais>) this.paisDao.findAllLike(pais, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Pais table.
	 * 
	 *  filterPais
	 *            Pais
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Pais>
	 *
	 * @param filterPais the filter pais
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<Pais> filter(Pais filterPais, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Pais> listaPais = this.paisDao.findAllLike(filterPais, jqGridRequestDto, false);
		Long recordNum = this.paisDao.findAllLikeCount(filterPais != null ? filterPais : new Pais(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Pais>> reorderSelection = this.paisDao.reorderSelection(filterPais, jqGridRequestDto,
					startsWith);
			return new JQGridResponseDto<Pais>(jqGridRequestDto, recordNum, listaPais, reorderSelection);
		}
		return new JQGridResponseDto<Pais>(jqGridRequestDto, recordNum, listaPais);
	}

	/**
	 * Searches rows in the Pais table.
	 * 
	 *  filterPais
	 *            Pais
	 *  searchPais
	 *            Pais
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Pais>>
	 *
	 * @param filterPais the filter pais
	 * @param searchPais the search pais
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<Pais>> search(Pais filterPais, Pais searchPais, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.paisDao.search(filterPais, searchPais, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Pais table.
	 * 
	 *  filterPais
	 *            Pais
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterPais the filter pais
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(Pais filterPais, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.paisDao.reorderSelection(filterPais, jqGridRequestDto, startsWith);
	}

}
